
########################################################################
# workingMessageCreate() -	Create the dialog that is used to issue
#                               a "working" message.
########################################################################
proc workingMessageCreate {} {
    iwidgets::dialogshell .working -title "Working...Please Wait..." -master .

#    .working configure -modality application

    set working [.working childsite]

    label $working.message -relief flat -text "working..."

    pack $working.message -anchor n -side top -expand yes -fill x
}

########################################################################
# workingMessagePopUp() -	Pops up the "working..." message dialog,
#                               which just stays there until turned off.
########################################################################
proc workingMessagePopUp {message {win .}} {

    [.working childsite].message configure -text $message
    update

    set newx [expr [winfo x $win] + ([winfo width $win]/2) - ([winfo width .working] / 2)]
    set newy [expr [winfo y $win] + ([winfo height $win]/2) - ([winfo height .working] / 2)]

    wm geometry .working [format "+%d+%d" $newx $newy]

    .working activate
    update
}

########################################################################
# workingMessageRemove() -	Removes the "working..." message dialog.
########################################################################
proc workingMessageRemove {} {
    .working deactivate
}
